"use client";

import React from "react";
import Link from "next/link";
import Image from "next/image";
import { Container } from "@/components/ui/container";
import { TypographyH3, TypographyP } from "@/components/ui/typography";
import { Heart, ShoppingBag, Truck, DollarSign } from "lucide-react";

const AboutPage: React.FC = () => {
  return (
    <div className="min-h-screen py-12 bg-gradient-to-b from-gray-50 to-white">
      <Container>
        {/* Hero Section */}
        <div className="text-center mb-16">
          <div className="inline-block mb-6">
            <div className="w-20 h-20 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center mx-auto shadow-lg">
              <Heart className="w-10 h-10 text-white" fill="white" />
            </div>
          </div>
          
          <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-gray-900 mb-6">
            قوة الأمل
          </h1>
          
          <TypographyH3 className="text-2xl md:text-3xl text-gray-600 font-medium">
            من محارب السرطان إلى بائع الأحذية الإلكتروني
          </TypographyH3>
        </div>

        {/* Main Story Card */}
        <div className="max-w-4xl mx-auto bg-white rounded-3xl shadow-2xl p-8 md:p-12 mb-12">
          {/* Hero Badge with Image */}
          <div className="flex flex-col items-center justify-center gap-6 mb-8">
            {/* Samir's Image */}
            <div className="relative w-48 h-48 md:w-64 md:h-64 rounded-full overflow-hidden shadow-2xl ring-4 ring-blue-100">
              <Image 
                src="/assets/samer.jpg" 
                alt="سمير صافي الحاتمي"
                fill
                className="object-cover"
                priority
              />
            </div>
            
            {/* Badge */}
            <div className="flex items-center justify-center gap-3 bg-gradient-to-r from-blue-50 to-purple-50 py-4 px-6 rounded-2xl w-full">
              <span className="text-4xl">🦸</span>
              <div className="text-right">
                <TypographyH3 className="text-2xl font-bold text-gray-900">
                  البطل: سمير صافي الحاتمي
                </TypographyH3>
                <p className="text-gray-600 font-medium">محارب سرطان</p>
              </div>
            </div>
          </div>

          {/* Story Content */}
          <div className="space-y-6 text-right leading-relaxed">
            <TypographyP className="text-xl font-semibold text-gray-900 italic">
              &quot;الحمد لله الذي منّ علي بقوة الأمل...
            </TypographyP>

            <TypographyP className="text-lg text-gray-700">
              قصتي بدأت عندما واجهت أعتى محنة في حياتي: مرض السرطان. الدواء الذي أحتاجه يتكلف أكثر من ٤٥٠٠$ للجرعة الواحدة! طرقت كل أبواب الحكومة... لكن دون استجابة. لم أستسلم.
            </TypographyP>

            <TypographyP className="text-lg text-gray-700 font-semibold">
              قررت أن أكون يدي التي تمتد لنفسي ولعائلتي...
            </TypographyP>

            <TypographyP className="text-lg text-gray-700">
              فأسست مشروعي الصغير: متجر إلكتروني لتسويق الأحذية.
            </TypographyP>
          </div>

          {/* Goal Section */}
          <div className="mt-10 bg-gradient-to-r from-amber-50 to-orange-50 rounded-2xl p-6">
            <div className="flex items-center gap-3 mb-4">
              <span className="text-3xl">🎯</span>
              <TypographyH3 className="text-2xl font-bold text-gray-900">الهدف</TypographyH3>
            </div>
            <TypographyP className="text-lg text-gray-700 text-right">
              توفير مصاريف علاجي ومصاريف جامعتي (أنا طالب مرحلة رابعة).
            </TypographyP>
          </div>
        </div>

        {/* Features Grid */}
        <div className="max-w-4xl mx-auto mb-12">
          <TypographyH3 className="text-3xl font-bold text-center mb-8 text-gray-900">
            مميزات المتجر
          </TypographyH3>
          
          <div className="grid md:grid-cols-2 gap-6">
            {/* Feature 1 */}
            <div className="bg-white rounded-2xl shadow-lg p-6 border-2 border-green-100 hover:border-green-300 transition-all">
              <div className="flex items-start gap-4">
                <div className="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center flex-shrink-0">
                  <DollarSign className="w-6 h-6 text-green-600" />
                </div>
                <div className="text-right flex-1">
                  <div className="flex items-center gap-2 mb-2">
                    <span className="text-2xl">✅</span>
                    <TypographyH3 className="text-xl font-bold text-gray-900">
                      أسعار مخفضة جداً
                    </TypographyH3>
                  </div>
                  <TypographyP className="text-gray-600">
                    لأني لا أدفع إيجار محل
                  </TypographyP>
                </div>
              </div>
            </div>

            {/* Feature 2 */}
            <div className="bg-white rounded-2xl shadow-lg p-6 border-2 border-blue-100 hover:border-blue-300 transition-all">
              <div className="flex items-start gap-4">
                <div className="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0">
                  <Truck className="w-6 h-6 text-blue-600" />
                </div>
                <div className="text-right flex-1">
                  <div className="flex items-center gap-2 mb-2">
                    <span className="text-2xl">✅</span>
                    <TypographyH3 className="text-xl font-bold text-gray-900">
                      توصيل لكل العراق
                    </TypographyH3>
                  </div>
                  <TypographyP className="text-gray-600">بسعر رمزي</TypographyP>
                </div>
              </div>
            </div>
          </div>

          {/* Delivery Prices */}
          <div className="mt-6 bg-white rounded-2xl shadow-lg p-6 border-2 border-purple-100">
            <TypographyH3 className="text-xl font-bold text-center mb-4 text-gray-900">
              أسعار التوصيل
            </TypographyH3>
            <div className="grid md:grid-cols-3 gap-4 text-center">
              <div className="bg-purple-50 rounded-xl p-4">
                <div className="text-3xl font-bold text-purple-600 mb-1">٥٠٠٠</div>
                <div className="text-sm text-gray-600">دينار</div>
                <div className="text-sm font-medium text-gray-700 mt-2">باقي المحافظات</div>
              </div>
              <div className="bg-blue-50 rounded-xl p-4">
                <div className="text-3xl font-bold text-blue-600 mb-1">٢٠٠٠</div>
                <div className="text-sm text-gray-600">دينار</div>
                <div className="text-sm font-medium text-gray-700 mt-2">داخل النجف</div>
              </div>
              <div className="bg-green-50 rounded-xl p-4">
                <div className="text-3xl font-bold text-green-600 mb-1">٤٠٠٠</div>
                <div className="text-sm text-gray-600">دينار</div>
                <div className="text-sm font-medium text-gray-700 mt-2">الأقضية والنواحي</div>
              </div>
            </div>
          </div>
        </div>

        {/* Journey Section */}
        <div className="max-w-4xl mx-auto bg-gradient-to-br from-green-50 to-teal-50 rounded-3xl shadow-lg p-8 md:p-12 mb-12">
          <div className="flex items-center gap-3 mb-6">
            <span className="text-4xl">🕌</span>
            <TypographyH3 className="text-2xl font-bold text-gray-900">
              الحمد لله
            </TypographyH3>
          </div>
          
          <TypographyP className="text-lg text-gray-700 text-right leading-relaxed">
            مرور ١٠ أشهر وأنا مستمر بدعمكم وفضله تعالى.
          </TypographyP>
        </div>

        {/* Call to Action */}
        <div className="max-w-4xl mx-auto bg-gradient-to-r from-blue-600 to-purple-600 rounded-3xl shadow-2xl p-8 md:p-12 text-white text-center">
          <TypographyH3 className="text-3xl font-bold mb-6">
            أطلب منكم ليس تبرعات...
          </TypographyH3>
          
          <TypographyP className="text-xl mb-8">
            بل دعم بمشاركة متجري ومتابعته
          </TypographyP>

          <div className="space-y-4 text-lg">
            <p className="font-semibold text-2xl">هذا حلمي...</p>
            <p className="font-semibold text-2xl">وهذا وقتي لأثبت أن المحارب لا يستسلم.</p>
          </div>

          <div className="mt-10 pt-8 border-t border-white/30">
            <TypographyP className="text-2xl font-bold mb-4">
              شكراً لكم...
            </TypographyP>
            <TypographyP className="text-xl">
              لأنكم جزء من رحلتي.
            </TypographyP>
          </div>
        </div>

        {/* Shopping Badge */}
        <div className="mt-12 text-center">
          <Link href="/" className="inline-flex items-center gap-3 bg-white rounded-full px-8 py-4 shadow-lg hover:shadow-xl transition-all hover:scale-105 cursor-pointer">
            <ShoppingBag className="w-8 h-8 text-blue-600" />
            <span className="text-xl font-bold text-gray-900">تسوق الآن وكن جزءاً من القصة</span>
          </Link>
        </div>
      </Container>
    </div>
  );
};

export default AboutPage;
