'use client';

import { useEffect, useState } from 'react';
import { useAuth } from '@/context/AuthContext';

export default function DebugAuth() {
  const auth = useAuth();
  const [token, setToken] = useState<string | null>(null);
  const [user, setUser] = useState<string | null>(null);

  useEffect(() => {
    if (typeof window !== 'undefined') {
      setToken(localStorage.getItem('auth_token'));
      setUser(localStorage.getItem('auth_user'));
    }
  }, []);

  return (
    <div className="p-8 max-w-4xl mx-auto">
      <h1 className="text-2xl font-bold mb-6">Auth Debug Info</h1>
      
      <div className="space-y-4">
        <div className="bg-gray-100 p-4 rounded">
          <h2 className="font-bold mb-2">From AuthContext:</h2>
          <pre className="text-sm">
            {JSON.stringify({
              isAuthenticated: auth.isAuthenticated,
              isLoading: auth.isLoading,
              hasUser: !!auth.user,
              hasToken: !!auth.token,
              user: auth.user,
            }, null, 2)}
          </pre>
        </div>

        <div className="bg-gray-100 p-4 rounded">
          <h2 className="font-bold mb-2">From localStorage:</h2>
          <pre className="text-sm">
            {JSON.stringify({
              hasToken: !!token,
              tokenLength: token?.length || 0,
              tokenPreview: token ? token.substring(0, 20) + '...' : 'null',
              hasUser: !!user,
              userPreview: user ? user.substring(0, 100) : 'null',
            }, null, 2)}
          </pre>
        </div>

        <div className="bg-blue-100 p-4 rounded">
          <h2 className="font-bold mb-2">API Base URL:</h2>
          <pre className="text-sm">
            {process.env.NEXT_PUBLIC_API_URL || 'http://localhost:8000/api'}
          </pre>
        </div>

        <div className="mt-6">
          <button
            onClick={() => window.location.href = '/profile'}
            className="bg-blue-500 text-white px-4 py-2 rounded mr-2"
          >
            Go to Profile
          </button>
          <button
            onClick={() => window.location.reload()}
            className="bg-gray-500 text-white px-4 py-2 rounded"
          >
            Refresh
          </button>
        </div>
      </div>
    </div>
  );
}
