import type { Metadata } from "next";
import "./globals.css";
import Navbar from "@/components/layout/Navbar";
import Footer from "@/components/layout/Footer";
import LocalStoragePolicyEnforcer from "@/components/LocalStoragePolicyEnforcer";
import { AuthProvider } from "@/context/AuthContext";
import { CartProvider } from "@/context/CartContext";
import { ToastProvider } from "@/context/ToastContext";
import { NextAuthProvider } from "@/components/providers/NextAuthProvider";

export const metadata: Metadata = {
  title: "SamSmy Webshop",
  description: "Samer Webshop Application",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="ar" dir="rtl">
      <body>
        <NextAuthProvider>
          <AuthProvider>
            <CartProvider>
              <ToastProvider>
                <LocalStoragePolicyEnforcer />
                <Navbar/>
                {children}
                <Footer/>
              </ToastProvider>
            </CartProvider>
          </AuthProvider>
        </NextAuthProvider>
      </body>
    </html>
  );
}
