import CategoriesNavigation from "@/components/CategoriesNavigation";
import FeaturedItems from "@/components/FeaturedItems";
import FlashSaleForBestSellers from "@/components/FlashSaleForBestSellers";
import Hero from "@/components/Hero";
import PackageShowcase from "@/components/PackageShowcase";
// import OurHappyCustomers from "@/components/OurHappyCustomers";
import SearchCTA from "@/components/SearchCTA";
import WhatWeProvide from "@/components/WhatWeProvide";
import { OptimizedLazyLoad } from "@/components/ui/optimized-lazy-load";
import { PerformancePanel } from "@/components/ui/performance-monitor";
import { Suspense } from "react";

// Loading components for better UX
function FeaturedItemsSkeleton() {
  return (
    <div className="py-12 px-4 md:px-6">
      <div className="container mx-auto">
        <div className="animate-pulse">
          <div className="h-8 bg-gray-200 rounded w-64 mb-8"></div>
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            {Array.from({ length: 6 }).map((_, i) => (
              <div key={i} className="h-64 bg-gray-200 rounded-lg"></div>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
}

export default function Home() {
  return (
    <div className="overflow-x-hidden">
      {/* Above-the-fold content - load immediately with high priority */}
      <Hero />
      <WhatWeProvide />
      <div className="hidden md:block">
        <CategoriesNavigation />
      </div>
      
      {/* Critical featured content - with Suspense for better loading */}
      <Suspense fallback={<FeaturedItemsSkeleton />}>
        <OptimizedLazyLoad
          rootMargin="50px"
          fallback={<FeaturedItemsSkeleton />}
        >
          <FeaturedItems />
        </OptimizedLazyLoad>
      </Suspense>
      
      {/* Secondary content - lazy loaded */}
      {/* <OptimizedLazyLoad
        rootMargin="100px"
        fallback={<div className="h-32 bg-gray-100 animate-pulse rounded-lg mx-4" />}
        delay={200}
      >
        <Banners />
      </OptimizedLazyLoad> */}

         <OptimizedLazyLoad
        rootMargin="100px"
        fallback={<div className="h-96 bg-gray-100 animate-pulse rounded-lg mx-4" />}
        delay={500}
      >
        <PackageShowcase />
      </OptimizedLazyLoad>
      
      <OptimizedLazyLoad
        rootMargin="100px"
        fallback={<div className="h-64 bg-gray-100 animate-pulse rounded-lg mx-4" />}
        delay={400}
      >
        <FlashSaleForBestSellers />
      </OptimizedLazyLoad>
        {/* Package Showcase Section */}
   
    
      
      {/* New arrivals with priority loading and caching */}
      {/* <Suspense fallback={<ProductsGridSkeleton />}>
        <OptimizedLazyLoad
          rootMargin="150px"
          fallback={<ProductsGridSkeleton />}
        >
          <ProductsGrid 
            title="وصل جديدنا"
            subtitle="اكتشف أحدث المنتجات المضافة إلى مجموعتنا"
            limit={8}
            sortBy="created_at"
            sortOrder="desc"
            priority={false} // Not above-the-fold
            enableCache={true}
          />
        </OptimizedLazyLoad>
      </Suspense> */}
      
      {/* Non-critical content - load last */}
      {/* <OptimizedLazyLoad
        rootMargin="200px"
        fallback={<div className="h-48 bg-gray-100 animate-pulse rounded-lg mx-4" />}
        delay={600}
      >
        <OurHappyCustomers />
      </OptimizedLazyLoad> */}
      
      <OptimizedLazyLoad
        rootMargin="200px"
        fallback={<div className="h-32 bg-gray-100 animate-pulse rounded-lg mx-4" />}
        delay={800}
      >
        <SearchCTA />
      </OptimizedLazyLoad>
      
      {/* Development performance panel */}
      <PerformancePanel />
    </div>
  );
}
