import React from 'react'

import { Container } from "@/components/ui/container";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { TypographyH3 } from './ui/typography';
import Image from "next/image";

const Banners: React.FC = () => {
    return (
        <section className="py-10 px-4 md:px-6">
            <Container>
                <div className="flex flex-wrap gap-5 items-stretch justify-center">
                    {/* Card 1 */}
                    <Card className="w-full sm:w-[610px] backdrop-blur-none shadow-none rounded-[21px] px-5 py-6 sm:pt-[53px] sm:pb-9" style={{ background: "#F3F4F6" }}>
                        <div className="flex h-full flex-col">
                            <TypographyH3 className="text-[36px] sm:text-[45px] leading-[46px] sm:leading-12 font-bold prompt text-black text-center tracking-[-0.9px]">Might Sound, <br />Everywhere</TypographyH3>
                            <div className="mt-6 sm:mt-[38px] sm:mr-[69px] relative grid place-items-end">
                                <div className="relative h-[180px] sm:h-[267px] w-[260px] sm:w-[323px]">
                                    <Image src="/assets/banner-1.png" alt="banner-1" fill className="w-full h-full object-cover" />
                                </div>
                                <Button className="absolute left-0 sm:left-11 bottom-[33px] inline-flex rounded-full hover:bg-black/85 bg-black text-white py-4 px-6 lg:px-[37px] text-[16px] leading-[21px] font-medium">
                                    تعال شوف
                                    <Image src="/assets/icons/arrow-down.svg" alt='arrow' width={18} height={18} />
                                </Button>
                            </div>
                        </div>
                    </Card>

                    {/* Card 2 */}
                    <Card className="w-full sm:w-[610px] backdrop-blur-none shadow-none rounded-[21px] px-5 sm:px-12 py-6 sm:pt-[53px] sm:pb-9" style={{ background: "#F3F4F6" }}>
                        <div className="grid grid-cols-1 sm:grid-cols-[1fr_auto] gap-3 sm:gap-4 items-start">
                            <div>
                                <TypographyH3 className="text-[40px] sm:text-[56px] leading-[50px] sm:leading-[70px] font-bold prompt text-black tracking-[-1.12px]">20% OFF</TypographyH3>
                                <p className="mt-2 text-[16px] md:text-[23px] leading-[22px] sm:leading-[29px] font-semibold text-black tracking-[-0.46px]">Special Christmas <br />Day Offer</p>
                            </div>
                            <Button className="sm:mt-2.5 w-fit inline-flex rounded-full hover:bg-black/85 bg-black text-white py-4 px-6 lg:px-[37px] text-[16px] leading-[21px] font-medium">
                                تعال شوف
                                <Image src="/assets/icons/arrow-down.svg" alt='arrow' width={18} height={18} />
                            </Button>
                        </div>
                        <div className="mt-4 sm:mt-0 flex justify-end">
                            <div className="relative h-[180px] sm:h-[267px] w-[260px] sm:w-[305px]">
                                <Image src="/assets/banner-2.png" alt="banner-2" fill className="w-full h-full object-cover" />
                            </div>
                        </div>
                    </Card>

                    {/* Card 3 */}
                    <Card className="w-full sm:w-[505px] backdrop-blur-none shadow-none rounded-[21px] py-6 sm:pt-[58px] px-5 sm:pl-[59px] sm:pb-[42px] sm:pr-10" style={{ background: "#F3F4F6" }}>
                        <div className="flex h-full flex-col">
                            <TypographyH3 className="text-[32px] md:text-[39px] leading-10 tracking-[-0.78px] sm:leading-[42px] prompt font-extrabold text-black md:text-left">Control Your <br />Daily Activity <br />On Yourself</TypographyH3>
                            <div className="mt-4 sm:mt-[21px] relative grid place-items-end md:place-items-end">
                                <div className="relative h-[180px] sm:h-[243px] w-[260px] sm:w-[263px]">
                                    <Image src="/assets/banner-3.png" alt="banner-3" fill className="w-full h-full object-cover" />
                                </div>
                                <Button className="absolute -left-1 bottom-[38px] inline-flex rounded-full hover:bg-black/85 bg-black text-white py-4 px-6 lg:px-[37px] text-[16px] leading-[21px] font-medium">
                                    تعال شوف
                                    <Image src="/assets/icons/arrow-down.svg" alt='arrow' width={18} height={18} />
                                </Button>
                            </div>
                        </div>
                    </Card>

                    {/* Card 4 */}
                    <Card className="w-full sm:w-[712px] backdrop-blur-none shadow-none rounded-[21px] py-6 px-5 sm:pt-[58px] sm:pb-[31px] sm:pr-9 sm:pl-[45px]" style={{ background: "#F3F4F6" }}>
                        <div className="flex flex-col justify-between gap-4 sm:gap-6">
                            <TypographyH3 className="text-[40px] md:text-[57px] leading-[50px] md:leading-[67px] prompt font-bold text-black tracking-[-1.14px] text-left sm:text-right">Travels Light, <br />Sounds Heavy</TypographyH3>
                            <div className="grid grid-cols-1 sm:grid-cols-[1fr_auto] items-start gap-6">
                                <div className="order-2 sm:order-1">
                                    <div className="relative h-[180px] md:h-[243px] w-full md:w-[371px]">
                                        <Image src="/assets/banner-4.png" alt="banner-4" fill className="w-full h-full object-contain" />
                                    </div>
                                </div>
                                <div className="order-1 sm:order-2 sm:mt-[15px] flex flex-col items-end text-right gap-4 sm:gap-[34px]">
                                    <p className="text-black text-[20px] sm:text-[23px] leading-[31px] font-medium tracking-[-0.46px]">20+ hours of <br />portable playtime</p>
                                    <Button className="inline-flex rounded-full hover:bg-black/85 bg-black text-white py-4 px-6 lg:px-[37px] text-[16px] leading-[21px] font-medium">
                                        تعال شوف
                                        <Image src="/assets/icons/arrow-down.svg" alt='arrow' width={18} height={18} />
                                    </Button>
                                </div>
                            </div>
                        </div>
                    </Card>
                </div>
            </Container>
        </section>
    )
}

export default Banners