"use client";

import React from 'react';
import { ShoppingCart } from 'lucide-react';
import { useCart } from '@/context/CartContext';
import { Button } from '@/components/ui/button';
import Link from 'next/link';

interface CartIconProps {
  className?: string;
}

const CartIcon: React.FC<CartIconProps> = ({ className = '' }) => {
  const { cart } = useCart();

  return (
    <Button
      variant="ghost"
      asChild
      className={`relative p-2 hover:bg-gray-100 ${className}`}
    >
      <Link href="/cart">
        <ShoppingCart className="h-6 w-6 text-gray-700" />
        {cart.totalItems > 0 && (
          <span className="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-5 w-5 flex items-center justify-center font-medium">
            {cart.totalItems > 99 ? '99+' : cart.totalItems}
          </span>
        )}
        <span className="sr-only">
          Shopping cart with {cart.totalItems} items
        </span>
      </Link>
    </Button>
  );
};

export default CartIcon;