"use client";
import React from "react";
import Image from "next/image";
import { Container } from "@/components/ui/container";
import { Button } from "@/components/ui/button";
import { TypographyH3, TypographyP } from "@/components/ui/typography";

type HeroProps = {
    className?: string;
};

export default function Hero({ className }: HeroProps) {
    return (
        <section className={className}>
            <div className="bg-[#F3F4F6] lg:min-h-[648px]">
                <Container className="max-w-[1440px] w-full flex flex-col lg:flex-row justify-between lg:gap-0 gap-8 items-stretch overflow-hidden">

                    {/* left section */}
                    <div className="px-5 lg:pl-10 lg:pr-0 xl:pl-[200px] pt-10 xl:pt-16">
                        <div className="lg:w-[400px] xl:w-[550px] relative">
                            <div className="bg-[#F5411C] shadow-[0px_29.53px_30.03px_0px_#0000001F] h-20 sm:h-[94px] left-[166px] sm:left-[180px] -top-2 sm:top-0 flex items-center justify-center px-7 sm:px-[35px] absolute rounded-[20px] sm:rounded-[28px] -rotate-2 ">
                                <TypographyH3 className="text-white text-[50px] sm:text-[57px] leading-[60px] tracking-[-1.14px] font-extrabold prompt">50%</TypographyH3>
                            </div> 
                            <TypographyH3 className="text-black text-[68px] sm:text-[74px] leading-[78px] sm:leading-[93px] font-extrabold prompt  tracking-[-1.48px] relative z-10">
                                {/* Great <br /> Products. Even Price */}
                                منتجات زينة<br /> وأسعار مناسبة
                            </TypographyH3>
                        </div>
                        <TypographyP className="mt-3.5 sm:mt-5 mb-5 sm:mb-[38px] text-black text-[16px] sm:text-[18px] leading-[26px] sm:leading-[30px] font-normal max-w-[400px]"> جودة عالية بأسعار مناسبة </TypographyP>
                        <Button className="sm:w-fit w-full flex rounded-full hover:bg-black/85 bg-black text-white py-4 px-6 lg:px-[37px] text-[16px] leading-[21px] font-medium">
                            تعال شوف
                            <Image src="/assets/icons/arrow-down.svg" alt='arrow' width={18} height={18} />
                        </Button>
                    </div>

                    {/* right section */}
                    <div className="relative w-full sm:w-[500px] md:w-[600px] lg:w-[660px] mx-auto lg:mx-0">
                        <Image
                            src="/assets/hero-section.png"
                            alt="Shopping cart in store"
                            width={680}
                            height={648}
                            className="w-full h-auto lg:h-[648px] object-cover"
                            priority
                        />
                        <Image
                            src="/assets/highest-quality.png"
                            alt="Highest Quality badge"
                            className="absolute bottom-6 sm:bottom-[60px] left-4 sm:left-8 md:left-0 md:rotate-3 md:bottom-[84px]"
                            width={160}
                            height={130}
                        />
                    </div>
                </Container>
            </div>
        </section>
    );
}
