"use client";

import React from "react";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import AllOrder from "./AllOrder";
import PresentOrder from "./PresentOrder";
import PreviousOrder from "./PreviousOrder";
import CancelOrder from "./CancelOrder";

export default function OrderTabs() {
  return (
    <div className="px-4 md:px-6">
      <div className="w-full max-w-[1240px] mx-auto">
        <Tabs defaultValue="all" className="w-full">
          <TabsList
            className="border-none"
            style={{
              background:
                "linear-gradient(140.28deg, rgba(255, 255, 255, 0.525) 1.44%, rgba(255, 255, 255, 0.18) 98.22%)",
              backdropFilter: "blur(8px)",
              boxShadow: "0px 4px 24px -1px #00000014",
            }}
          >
            <TabsTrigger value="all" className="text-[#4B4B4B]">
              جميع الطلبات
            </TabsTrigger>
            <TabsTrigger value="present" className="text-[#4B4B4B]">
              الطلبات الحالية
            </TabsTrigger>
            <TabsTrigger value="previous" className="text-[#4B4B4B]">
              الطلبات السابقة
            </TabsTrigger>
            <TabsTrigger
              value="cancel"
              className="text-[#4B4B4B] cursor-pointer data-[state=active]:bg-red-600 data-[state=active]:text-white border-none md:px-6"
            >
              الطلبات الملغاة
            </TabsTrigger>
          </TabsList>

          <TabsContent value="all">
            <AllOrder />
          </TabsContent>

          <TabsContent value="present">
            <PresentOrder />
          </TabsContent>

          <TabsContent value="previous">
            <PreviousOrder />
          </TabsContent>

          <TabsContent value="cancel">
            <CancelOrder />
          </TabsContent>
        </Tabs>
      </div>
    </div>
  );
}
