"use client"
import React, { useState, useEffect } from 'react';
import { Card, CardContent } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Container } from './ui/container';
import { TypographyH3 } from './ui/typography';
import Image from 'next/image';
import { testimonials } from '@/data/testimonials';
import { Carousel, CarouselContent, CarouselItem, CarouselApi } from '@/components/ui/carousel';
import Autoplay from 'embla-carousel-autoplay';

const OurHappyCustomers: React.FC = () => {
    const [api, setApi] = useState<CarouselApi>();
    const [activeSlide, setActiveSlide] = useState<number>(0);

    useEffect(() => {
        if (!api) return;

        api.on("select", () => {
            setActiveSlide(api.selectedScrollSnap());
        });
    }, [api]);

    const handleSlideChange = (index: number): void => {
        api?.scrollTo(index);
    };

    const getVisiblePages = (): number[] => {
        const totalPages = testimonials.length;
        const maxVisible = 4;

        if (totalPages <= maxVisible) {
            return Array.from({ length: totalPages }, (_, i) => i);
        }

        const start = Math.max(0, activeSlide - 1);
        const end = Math.min(totalPages, start + maxVisible);

        if (end === totalPages) {
            return Array.from({ length: end - maxVisible }, (_, i) => Math.max(0, end - maxVisible) + i);
        }

        return Array.from({ length: end - start }, (_, i) => start + i);
    };

    const visiblePages = getVisiblePages();

    return (
        <div className='w-full px-4 md:px-6 mt-10 mb-24 md:mb-[130px]'>
            <Container className="w-full">
                <TypographyH3 className="text-black tracking-[-0.94px] text-[40px] sm:text-[47px] leading-12 sm:leading-[59px] font-bold prompt">
                    OUR HAPPY <span className="text-[#F5411C]">CUSTOMERS</span>
                </TypographyH3>

                {/* testimonial carousel */}
                <Carousel
                    setApi={setApi}
                    opts={{
                        // align: "start",
                        loop: true,
                    }}
                    plugins={[
                        Autoplay({
                            delay: 8000,
                        }),
                    ]}
                    className="mt-6 sm:mt-10 lg:mt-12 w-full"
                >
                    <CarouselContent className="flex items-start md:items-center justify-between gap-6 bg-white">
                        {testimonials.map((testimonial) => (
                            <CarouselItem key={testimonial.id} className="basis-full flex flex-col md:flex-row items-center justify-between gap-4 sm:gap-6 w-full">
                                {/* left card */}
                                <Card className="w-full md:w-[350px] lg:w-[400px] relative z-10 border-0 shadow-none bg-transparent p-0">
                                    <div className="p-4 md:p-0 bg-[#F5411C] w-full md:w-[350px] lg:w-[400px] h-[420px] md:h-[720px] relative">
                                        <div className="md:absolute top-10 lg:top-[60px] left-[90px] lg:left-[150px] w-full md:w-[318px] h-[300px] md:h-[500px] overflow-hidden">
                                            <img
                                                src={testimonial.image}
                                                alt={testimonial.name}
                                                className="w-full h-full sm:object-contain object-cover transition-opacity duration-500"
                                            />
                                        </div>
                                        <div className="text-center md:text-left mt-2 md:mt-0 md:absolute bottom-[78px] left-[90px] lg:left-[150px]">
                                            <h3 className="text-[28px] leading-8 manrope font-extrabold text-[#FAFAFA] mb-2">{testimonial.name}</h3>
                                            <p className="text-[16px] leading-[22px] manrope font-normal text-[#FAFAFA]">{testimonial.position}</p>
                                        </div>
                                    </div>
                                </Card>

                                {/* right side */}
                                <Card className="bg-transparent w-full md:max-w-2xl xl:pr-[70px] md:pl-[50px] xl:pl-0 relative border-0 shadow-none">
                                    <CardContent className="p-0 w-full">
                                        <div className="w-full">
                                            <div className="mb-4 sm:mb-[30px]">
                                                <Image src='/assets/icons/quotes.svg' alt='quotes' width={60} height={60} />
                                            </div>

                                            <h2 className="text-[#202020] text-[28px] sm:text-[40px] lg:text-[48px] manrope leading-8 sm:leading-12 lg:leading-14 font-extrabold mb-4 sm:mb-[30px] transition-opacity duration-500">
                                                {testimonial.quote}
                                            </h2>

                                            <p className="text-[#808080] text-[18px] sm:text-[22px] lg:text-[28px] manrope leading-6 sm:leading-8 lg:leading-[46px] font-semibold mb-4 sm:mb-[30px] transition-opacity duration-500">
                                                {testimonial.description}
                                            </p>

                                            <div className="flex items-end justify-end">
                                                <Image src='/assets/icons/quotes.svg' alt='quotes' width={60} height={60} />
                                            </div>
                                        </div>

                                        {/* pagination buttons */}
                                        <div className="flex items-end justify-end mt-8 sm:mt-14 lg:mt-[118px]">
                                            <div className="flex items-center gap-5">
                                                {visiblePages.map((pageIndex) => (
                                                    <React.Fragment key={pageIndex}>
                                                        <Button
                                                            variant="ghost"
                                                            onClick={() => handleSlideChange(pageIndex)}
                                                            className={`text-[22px] leading-[30px] font-extrabold manrope px-0 h-auto hover:bg-transparent transition-colors ${activeSlide === pageIndex ? 'text-black' : 'text-[#808080] hover:text-gray-400'
                                                                }`}
                                                        >
                                                            {String(pageIndex + 1).padStart(2, '0')}
                                                            {activeSlide === pageIndex && <div className="w-[100px] h-[3px] bg-black" />}
                                                        </Button>
                                                    </React.Fragment>
                                                ))}
                                            </div>
                                        </div>
                                    </CardContent>
                                </Card>
                            </CarouselItem>
                        ))}
                    </CarouselContent>
                </Carousel>
            </Container>
        </div>
    );
};

export default OurHappyCustomers;