"use client";
import React from "react";
import { Container } from "../ui/container";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "../ui/tabs";
import RatingAndReviews from "./RatingAndReviews";

interface ProductReviewsProps {
    productId?: number;
    productName?: string;
}

const ProductReviews: React.FC<ProductReviewsProps> = ({ productId, productName }) => {
    const [activeTab, setActiveTab] = React.useState<string>("reviews");
    const t = {
        details: 'تفاصيل المنتج',
        reviews: 'التقييمات والمراجعات',
        faqs: 'الأسئلة الشائعة',
        loadingReviews: 'جاري تحميل المراجعات...',
        detailsTitle: 'تفاصيل المنتج:',
        faqsContent: 'محتوى الأسئلة الشائعة.'
    };

    return (
        <div className="px-4 md:px-6 w-full mb-12 mt-5">
            <Container>
                {/* Tabs header */}
                <Tabs value={activeTab} onValueChange={setActiveTab} className="w-full">
                    <TabsList className="w-full grid grid-cols-3 border-b border-[#0000001A] bg-transparent rounded-none p-0!">
                        <TabsTrigger
                            value="details"
                            className="rounded-none text-[#00000099] hover:bg-transparent data-[state=active]:text-black data-[state=active]:bg-transparent relative after:absolute after:left-0 after:right-0 after:-bottom-px after:h-0.5 after:bg-transparent data-[state=active]:after:bg-[#000000] data-[state=active]:font-medium p-0! pb-4! sm:pb-6! text-[12px] sm:text-[20px]! leading-3.5 font-normal"
                        >
                            {t.details}
                        </TabsTrigger>
                        <TabsTrigger
                            value="reviews"
                            className="rounded-none text-[#00000099] hover:bg-transparent data-[state=active]:text-black data-[state=active]:bg-transparent relative after:absolute after:left-0 after:right-0 after:-bottom-px after:h-0.5 after:bg-transparent data-[state=active]:after:bg-[#000000] data-[state=active]:font-medium p-0! pb-4! sm:pb-6! text-[12px] sm:text-[20px]! leading-3.5 font-normal"
                        >
                            {t.reviews}
                        </TabsTrigger>
                        <TabsTrigger
                            value="faqs"
                            className="rounded-none text-[#00000099] hover:bg-transparent data-[state=active]:text-black data-[state=active]:bg-transparent relative after:absolute after:left-0 after:right-0 after:-bottom-px after:h-0.5 after:bg-transparent data-[state=active]:after:bg-[#000000] data-[state=active]:font-medium p-0! pb-4! sm:pb-6! text-[12px] sm:text-[20px]! leading-3.5 font-normal"
                        >
                            {t.faqs}
                        </TabsTrigger>
                    </TabsList>

                    <TabsContent value="reviews" className="mt-6">
                        {productId && productName ? (
                            <RatingAndReviews productId={productId} productName={productName} />
                        ) : (
                            <p className="text-center text-gray-500">{t.loadingReviews}</p>
                        )}
                    </TabsContent>

                    {/* Other tabs placeholders */}
                    <TabsContent value="details" className="pt-6 text-[22px] sm:text-[24px] leading-[29px] font-bold">
                        {t.detailsTitle}
                    </TabsContent>
                    <TabsContent value="faqs" className="pt-6 text-[22px] sm:text-[24px] leading-[29px] font-bold">
                        {t.faqsContent}
                    </TabsContent>
                </Tabs>
            </Container>
        </div>
    );
};

export default ProductReviews;
