"use client";
import React, { useState } from "react";
import ReviewsList from "../Reviews/ReviewsList";
import WriteReviewModal from "../Reviews/WriteReviewModal";
import { Button } from "../ui/button";

interface RatingAndReviewsProps {
    productId: number;
    productName: string;
}

const RatingAndReviews: React.FC<RatingAndReviewsProps> = ({ productId, productName }) => {
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [refreshKey, setRefreshKey] = useState(0);

    const t = {
        customerReviews: 'مراجعات العملاء',
        writeReview: 'اكتب مراجعة'
    };

    const handleReviewSuccess = () => {
        setRefreshKey(prev => prev + 1);
    };

    return (
        <div>
            <div className="flex items-center justify-between mb-6">
                <h2 className="text-2xl font-bold">{t.customerReviews}</h2>
                <Button
                    onClick={() => setIsModalOpen(true)}
                    className="bg-black text-white hover:bg-gray-800 rounded-full px-8"
                >
                    {t.writeReview}
                </Button>
            </div>

            <ReviewsList key={refreshKey} productId={productId} />

            <WriteReviewModal
                productId={productId}
                productName={productName}
                isOpen={isModalOpen}
                onClose={() => setIsModalOpen(false)}
                onSuccess={handleReviewSuccess}
            />
        </div>
    );
};

export default RatingAndReviews;
