'use client';

import React from 'react';
import Link from 'next/link';
import { Container } from "@/components/ui/container";
import { Card } from "@/components/ui/card";
import { TypographyH3 } from "@/components/ui/typography";
import Image from "next/image";
import { useCategories } from "@/hooks/useCategories";

// Icon mapping for categories
const getCategoryIcon = (categoryName: string): string => {
    const name = categoryName.toLowerCase();
    
    if (name.includes('computer') || name.includes('laptop')) return '/assets/icons/computer-laptop.svg';
    if (name.includes('mobile') || name.includes('phone')) return '/assets/icons/mobile-phone.svg';
    if (name.includes('camera') || name.includes('imaging')) return '/assets/icons/camera.svg';
    if (name.includes('tv') || name.includes('smart box')) return '/assets/icons/tv-smart-box.svg';
    if (name.includes('home') || name.includes('appliance')) return '/assets/icons/home-appliance.svg';
    if (name.includes('accessories') || name.includes('accessory')) return '/assets/icons/accessories.svg';
    if (name.includes('fashion') || name.includes('clothing')) return '/assets/icons/accessories.svg';
    if (name.includes('sports') || name.includes('outdoor')) return '/assets/icons/other-categories.svg';
    
    return '/assets/icons/other-categories.svg';
};

const WhatWeProvide: React.FC = () => {
    const { categories, loading, error } = useCategories();

    // Get parent categories (no limit, show all available)
    const parentCategories = categories
        .filter(cat => cat.parent_id === null);

    if (loading) {
        return (
            <section className="px-4 md:px-6 py-14 lg:py-[105px] relative">
                <Container>
                    <div className="flex flex-col items-center gap-10 md:gap-[51px]">
                        <TypographyH3 className="text-center text-[40px] sm:text-[60px] lg:text-[74px] leading-[50px] sm:leading-[70px] lg:leading-[93px] font-extrabold prompt tracking-[-1.48px]">
                            <span className="text-[#F5411C]">شنو</span> نقدملكم؟
                        </TypographyH3>
                        <div className="flex justify-center w-full">
                            <div className={`grid gap-x-4 gap-y-6 sm:gap-6 xl:gap-[68px] ${
                                parentCategories.length <= 3 ? 'grid-cols-3' :
                                parentCategories.length === 4 ? 'grid-cols-2 sm:grid-cols-4' :
                                parentCategories.length === 5 ? 'grid-cols-3 sm:grid-cols-5' :
                                parentCategories.length === 6 ? 'grid-cols-3 sm:grid-cols-6' :
                                'grid-cols-3 sm:grid-cols-4 lg:grid-cols-7'
                            }`}>
                            {[1, 2, 3, 4, 5, 6, 7].map((i) => (
                                <div key={i} className="flex flex-col items-center gap-4 sm:gap-6 animate-pulse">
                                    <div className="w-[60px] sm:w-[85px] h-[60px] sm:h-[85px] rounded-full bg-gray-200"></div>
                                    <div className="h-4 bg-gray-200 rounded w-20"></div>
                                </div>
                            ))}
                            </div>
                        </div>
                    </div>
                </Container>
            </section>
        );
    }

    if (error) {
        return null; // Silently fail, don't break the page
    }

    return (
        <section className="px-4 md:px-6 py-14 lg:py-[105px] relative">
            <Image src='/assets/icons/line.svg' alt='line' width={97} height={6} className='sm:w-[97px] w-[60px] absolute top-10 sm:top-[69px] -left-4' />
            <Container className='relative'>
                <Image src='/assets/icons/star-2.svg' alt='star' width={27} height={27} className='absolute top-14 lg:top-2 left-0 md:left-[74px]' />
                <Image src='/assets/icons/line.svg' alt='line' width={97} height={6} className='sm:w-[97px] w-[60px] absolute top-14 sm:top-10 -right-4 lg:right-[70px]' />
                <Image src='/assets/icons/star-2.svg' alt='star' width={27} height={27} className='absolute -top-9 sm:-top-[22px] right-0 sm:right-[30px]' />
                <div className="flex flex-col items-center gap-10 md:gap-[51px]">
                    <TypographyH3 className="text-center text-[40px] sm:text-[60px] lg:text-[74px] leading-[50px] sm:leading-[70px] lg:leading-[93px] font-extrabold prompt tracking-[-1.48px]">
                         <span className="text-[#F5411C]">شنو</span>  نقدملكم؟
                    </TypographyH3>

                    <div className="flex justify-center w-full">
                        <div className={`grid gap-x-4 gap-y-6 sm:gap-6 xl:gap-[68px] ${
                            parentCategories.length <= 3 ? 'grid-cols-3' :
                            parentCategories.length === 4 ? 'grid-cols-2 sm:grid-cols-4' :
                            parentCategories.length === 5 ? 'grid-cols-3 sm:grid-cols-5' :
                            parentCategories.length === 6 ? 'grid-cols-3 sm:grid-cols-6' :
                            'grid-cols-3 sm:grid-cols-4 lg:grid-cols-7'
                        }`}>
                            {parentCategories.map((category) => (
                                <Link 
                                key={category.id} 
                                href={`/products?category=${category.id}`}
                                className="flex flex-col items-center gap-4 sm:gap-6 group cursor-pointer"
                            >
                                <Card className="w-[60px] sm:w-[85px] h-[60px] sm:h-[85px] rounded-full flex items-center justify-center group-hover:shadow-lg transition-shadow">
                                    <Image
                                        src={getCategoryIcon(category.name)}
                                        alt={category.name}
                                        width={40}
                                        height={40}
                                        className="w-8 h-8 sm:w-10 sm:h-10"
                                    />
                                </Card>
                                <h4 className="text-center text-[#2C2C2C] text-[16px] sm:text-[18px] font-medium leading-[20px] sm:leading-[23px] group-hover:text-[#F5411C] transition-colors">
                                    {category.name}
                                </h4>
                            </Link>
                        ))}
                        </div>
                    </div>
                </div>
            </Container>
        </section>
    );
};

export default WhatWeProvide;