"use client";

import React from "react";
import Link from "next/link";
import Logo from "../Logo";
import { Button } from "@/components/ui/button";
import { Container } from "@/components/ui/container";
import { TypographyH3, TypographyP, TypographySmall } from "@/components/ui/typography";
import type { FooterSection, FooterContactItem } from "@/types/footer";
import Image from "next/image";

const footerSections: FooterSection[] = [
    {
        title: "الشركة",
        links: [
            { href: "/about", label: "من نحن" },
            { href: "#", label: "آراء العملاء" },
        ],
    },
    {
        title: "معلومات",
        links: [
            { href: "#", label: "مركز المساعدة" },
            { href: "#", label: "طرق الدفع" },
            // { href: "#", label: "الإرجاع والاسترداد" },
        ],
    },
];

const contactItems: ReadonlyArray<FooterContactItem> = [
    { icon: '/assets/icons/phone.svg', value: "(+1) 123-456-7890" },
    { icon: '/assets/icons/gmail.svg', value: "email@youremail.com" },
];

const Footer: React.FC = () => {
    return (
        <footer className="w-full px-4 lg:px-6 pt-12 sm:pt-20 md:pt-28 lg:pt-36 pb-10 md:pb-20 sm:text-left text-center">
            <Container>
                <div className="flex items-center sm:items-start gap-6 justify-between sm:flex-row flex-col">

                    <div className="flex items-center sm:items-start flex-col justify-center">
                        <Logo />
                        <TypographyP className="mt-3 sm:mt-6 lg:mt-12 max-w-sm whitespace-pre-line">
                            أشياء زينة، خدمة أحلى، وثقة دائمة. دايماً بخدمتكم!
                        </TypographyP>
                    </div>

                    <div className="w-full max-w-[720px] flex items-center sm:items-start sm:flex-row flex-col justify-between flex-wrap gap-6 sm:gap-5">
                        {footerSections.map((section) => (
                            <div key={section.title} className="space-y-2.5 sm:space-y-[13px]">
                                <TypographyH3>{section.title}</TypographyH3>
                                <ul className="space-y-2.5 sm:space-y-[13px]">
                                    {section.links.map((link) => (
                                        <li key={link.label}>
                                            <Button
                                                variant="ghost"
                                                className="p-0 text-[18px] leading-[29px] font-normal text-black hover:text-black/70 justify-start hover:bg-transparent"
                                            >
                                                <Link href={link.href}>{link.label}</Link>
                                            </Button>
                                        </li>
                                    ))}
                                </ul>
                            </div>
                        ))}

                        <div className="space-y-4 sm:space-y-[25px]">
                            <TypographyH3>تواصل معنا</TypographyH3>
                            <ul className="space-y-4 sm:space-y-[25px]">
                                {contactItems.map(({ icon: Icon, value }, idx) => (
                                    <li key={idx} className="flex items-center gap-2.5">
                                        <Image src={Icon} alt="" width={23} height={23} />
                                        <TypographySmall >{value}</TypographySmall>
                                    </li>
                                ))}
                            </ul>
                        </div>
                    </div>
                </div>
            </Container>
        </footer>
    );
};

export default Footer;
