import * as React from "react"
import { cva, type VariantProps } from "class-variance-authority"

import { cn } from "@/lib/utils"

const badgeVariants = cva(
  "inline-flex items-center justify-center rounded-lg px-3 py-1.5 text-sm font-bold ring-inset transition-colors focus:outline-none",
  {
    variants: {
      variant: {
        default:
          "bg-primary text-primary-foreground hover:bg-primary/80",
        secondary:
          "bg-secondary text-secondary-foreground hover:bg-secondary/80",
        destructive:
          "bg-destructive text-destructive-foreground hover:bg-destructive/80",
        outline:
          "text-foreground",
        dark:
          "bg-[#1F2537] text-[#EDEDEF]",
        lime:
          "bg-[#AFE638] text-[#1F2537]",
        red:
          "bg-[#F5411C] text-white",
        gray:
          "bg-[#F1F1F2] text-[#1F2537]",
        yellow:
          "bg-[#FFE921] text-black",
      },
      size: {
        default: "text-[15px]",
        sm: "text-xs",
        lg: "text-base"
      }
    },
    defaultVariants: {
      variant: "default",
      size: "default",
    },
  }
)

export interface BadgeProps
  extends React.HTMLAttributes<HTMLDivElement>,
    VariantProps<typeof badgeVariants> {
  count?: number;
}

function Badge({ className, variant, size, count, ...props }: BadgeProps) {
  return (
    <div className={cn(badgeVariants({ variant, size }), className)} {...props}>
      {count !== undefined ? count : props.children}
    </div>
  )
}

export { Badge, badgeVariants }
