import * as React from "react";
import * as TabsPrimitive from "@radix-ui/react-tabs";

import { cn } from "@/lib/utils";

const Tabs = TabsPrimitive.Root;

const TabsList = React.forwardRef<
  React.ElementRef<typeof TabsPrimitive.List>,
  React.ComponentPropsWithoutRef<typeof TabsPrimitive.List>
>(({ className, ...props }, ref) => (
  <TabsPrimitive.List
    ref={ref}
    className={cn(
      "inline-flex items-center justify-between rounded-full p-[7px] px-2 md:px-6 md:pt-3.5 md:pb-3 text-foreground",
      "w-full max-w-full overflow-hidden md:overflow-x-auto gap-1 sm:gap-2",
      className
    )}
    {...props}
  />
));
TabsList.displayName = TabsPrimitive.List.displayName;

const TabsTrigger = React.forwardRef<
  React.ElementRef<typeof TabsPrimitive.Trigger>,
  React.ComponentPropsWithoutRef<typeof TabsPrimitive.Trigger>
>(({ className, ...props }, ref) => (
  <TabsPrimitive.Trigger
    ref={ref}
    className={cn(
      "inline-flex items-center cursor-pointer justify-center whitespace-nowrap rounded-full px-0 md:px-6 py-2.5 md:py-[20.5px] text-[10px] md:text-[22px] leading-[15px] md:leading-[25px] sm:leading-[27px] font-medium transition-colors",
      "text-[#4B4B4B] hover:bg-black/5",
      "data-[state=active]:bg-black data-[state=active]:text-white data-[state=active]:px-4 data-[state=active]:text-[12px] md:data-[state=active]:px-6 md:data-[state=active]:text-[22px] data-[state=active]:min-w-[93px] md:data-[state=active]:min-w-[250px] xl:data-[state=active]:min-w-[346px] data-[state=active]:font-bold",
      "focus-visible:outline-none disabled:pointer-events-none disabled:opacity-50",
      className
    )}
    {...props}
  />
));
TabsTrigger.displayName = TabsPrimitive.Trigger.displayName;

const TabsContent = React.forwardRef<
  React.ElementRef<typeof TabsPrimitive.Content>,
  React.ComponentPropsWithoutRef<typeof TabsPrimitive.Content>
>(({ className, ...props }, ref) => (
  <TabsPrimitive.Content
    ref={ref}
    className={cn("mt-4 focus-visible:outline-none", className)}
    {...props}
  />
));
TabsContent.displayName = TabsPrimitive.Content.displayName;

export { Tabs, TabsList, TabsTrigger, TabsContent };
