import * as React from "react";
import { cn } from "@/lib/utils";

export function TypographyH3({
    className,
    ...props
}: React.HTMLAttributes<HTMLHeadingElement>) {
    return (
        <h3
            className={cn("text-[22px] leading-[35px] font-extrabold text-black", className)}
            {...props}
        />
    );
}

export function TypographyH4({
    className,
    ...props
}: React.HTMLAttributes<HTMLHeadingElement>) {
    return (
        <h3
            className={cn("text-[12px] sm:text-[18px] leading-7 font-medium text-black", className)}
            {...props}
        />
    );
}

export function TypographyP({  
    className,
    ...props
}: React.HTMLAttributes<HTMLParagraphElement>) {
    return (
        <p className={cn("text-[18px] leading-7 font-normal text-black", className)} {...props} />
    );
}

export function TypographySmall({
    className,
    ...props
}: React.HTMLAttributes<HTMLSpanElement>) {
    return (
        <span
            className={cn("text-[18px] leading-[29px] font-normal text-black", className)}
            {...props}
        />
    );
}
