// Product image utilities
export const productImageCategories = {
  electronics: [
    'https://images.unsplash.com/photo-1505740420928-5e560c06d30e?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1572635196237-14b3f281503f?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1586953208448-b95a79798f07?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1542291026-7eec264c27ff?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1593642702821-c8da6771f0c6?w=600&h=600&fit=crop',
  ],
  fashion: [
    'https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1503342217505-b0a15ec3261c?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1515372039744-b8f02a3ae446?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1562157873-818bc0726f68?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1556905055-8f358a7a47b2?w=600&h=600&fit=crop',
  ],
  home: [
    'https://images.unsplash.com/photo-1586023492125-27b2c045efd7?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1560472354-b33ff0c44a43?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1555041469-a586c61ea9bc?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1615800001065-981777585ce1?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1571898223382-b0078e24c499?w=600&h=600&fit=crop',
  ],
  sports: [
    'https://images.unsplash.com/photo-1571019613454-1cb2f99b2d8b?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1544966503-7cc5ac882d5f?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1517466787929-bc90951d0974?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1606107557195-0e29a4b5b4aa?w=600&h=600&fit=crop',
    'https://images.unsplash.com/photo-1584464491033-06628f3a6b7b?w=600&h=600&fit=crop',
  ],
};

export function getRandomProductImage(category?: string): string {
  let images: string[];
  
  if (category) {
    const lowerCategory = category.toLowerCase();
    if (lowerCategory.includes('electronic') || lowerCategory.includes('computer') || lowerCategory.includes('phone') || lowerCategory.includes('camera') || lowerCategory.includes('tv') || lowerCategory.includes('audio')) {
      images = productImageCategories.electronics;
    } else if (lowerCategory.includes('clothing') || lowerCategory.includes('shoes') || lowerCategory.includes('fashion') || lowerCategory.includes('accessories')) {
      images = productImageCategories.fashion;
    } else if (lowerCategory.includes('home') || lowerCategory.includes('kitchen') || lowerCategory.includes('furniture') || lowerCategory.includes('appliance')) {
      images = productImageCategories.home;
    } else if (lowerCategory.includes('sport') || lowerCategory.includes('fitness') || lowerCategory.includes('outdoor')) {
      images = productImageCategories.sports;
    } else {
      images = [...productImageCategories.electronics, ...productImageCategories.fashion];
    }
  } else {
    images = [...productImageCategories.electronics, ...productImageCategories.fashion];
  }
  
  return images[Math.floor(Math.random() * images.length)];
}

export function getProductImages(category?: string, count: number = 3): string[] {
  const images: string[] = [];
  const availableImages = category ? getAvailableImages(category) : getAllImages();
  
  for (let i = 0; i < count; i++) {
    images.push(availableImages[Math.floor(Math.random() * availableImages.length)]);
  }
  
  return images;
}

function getAvailableImages(category: string): string[] {
  const lowerCategory = category.toLowerCase();
  if (lowerCategory.includes('electronic') || lowerCategory.includes('computer') || lowerCategory.includes('phone') || lowerCategory.includes('camera') || lowerCategory.includes('tv') || lowerCategory.includes('audio')) {
    return productImageCategories.electronics;
  } else if (lowerCategory.includes('clothing') || lowerCategory.includes('shoes') || lowerCategory.includes('fashion') || lowerCategory.includes('accessories')) {
    return productImageCategories.fashion;
  } else if (lowerCategory.includes('home') || lowerCategory.includes('kitchen') || lowerCategory.includes('furniture') || lowerCategory.includes('appliance')) {
    return productImageCategories.home;
  } else if (lowerCategory.includes('sport') || lowerCategory.includes('fitness') || lowerCategory.includes('outdoor')) {
    return productImageCategories.sports;
  }
  return productImageCategories.electronics;
}

function getAllImages(): string[] {
  return [
    ...productImageCategories.electronics,
    ...productImageCategories.fashion,
    ...productImageCategories.home,
    ...productImageCategories.sports,
  ];
}

// Fallback placeholder image
export const PLACEHOLDER_IMAGE = 'https://via.placeholder.com/600x600/f0f0f0/888888?text=Product+Image';