export function isLocalStorageEnabled(): boolean {
  if (typeof window === 'undefined') return false;
  try {
    const raw = localStorage.getItem('app_settings');
    if (!raw) return true; // default enabled
    const settings = JSON.parse(raw);
    if (typeof settings.use_local_storage === 'boolean') {
      return settings.use_local_storage;
    }
    return true;
  } catch {
    return true;
  }
}

export function getAppSettings(): Record<string, unknown> | null {
  if (typeof window === 'undefined') return null;
  try {
    const raw = localStorage.getItem('app_settings');
    return raw ? JSON.parse(raw) : null;
  } catch {
    return null;
  }
}
