import { api } from '@/lib/api';
import type { PackageDeal, PackageDealsResponse } from '@/types/package';

export const packageService = {
  /**
   * Get all package deals with pagination
   */
  async getPackageDeals(params?: {
    per_page?: number;
    available_only?: boolean;
    page?: number;
  }): Promise<PackageDealsResponse> {
    const queryParams = new URLSearchParams();
    
    if (params?.per_page) queryParams.append('per_page', params.per_page.toString());
    if (params?.available_only !== undefined) queryParams.append('available_only', params.available_only ? '1' : '0');
    if (params?.page) queryParams.append('page', params.page.toString());

    const response = await api.get<PackageDealsResponse>(
      `/packages${queryParams.toString() ? '?' + queryParams.toString() : ''}`
    );
    
    return response;
  },

  /**
   * Get featured package deals (limited to 6)
   */
  async getFeaturedPackages(): Promise<PackageDeal[]> {
    const response = await api.get<{ data: PackageDeal[] }>('/packages/featured');
    return response.data;
  },

  /**
   * Get a single package deal by slug
   */
  async getPackageBySlug(slug: string): Promise<PackageDeal> {
    const response = await api.get<{ data: PackageDeal }>(`/packages/${slug}`);
    return response.data;
  },
};
