export interface CartItem {
  id: string;
  productId: string;
  title: string;
  price: number;
  imageSrc: string;
  quantity: number;
  slug?: string;
}

export interface Cart {
  items: CartItem[];
  totalItems: number;
  totalPrice: number;
}

export interface CartContextType {
  cart: Cart;
  addToCart: (product: {
    id: string;
    title: string;
    price: number | string;
    imageSrc: string;
    slug?: string;
  }, quantity?: number) => Promise<void>;
  removeFromCart: (productId: string) => Promise<void>;
  updateQuantity: (productId: string, quantity: number) => Promise<void>;
  clearCart: () => Promise<void>;
  getItemQuantity: (productId: string) => number;
}