export interface PackageProduct {
  id: number;
  name: string;
  slug: string;
  images: string[];
  base_price: number;
  pivot: {
    quantity: number;
  };
}

export interface PackageDeal {
  id: number;
  name: string;
  slug: string;
  description: string | null;
  original_price: number;
  package_price: number;
  discount_percentage: number;
  images: string[];
  is_active: boolean;
  stock: number;
  starts_at: string | null;
  ends_at: string | null;
  products: PackageProduct[];
  available?: boolean;
  savings?: number;
  created_at: string;
  updated_at: string;
}

export interface PackageDealsResponse {
  data: PackageDeal[];
  meta: {
    current_page: number;
    last_page: number;
    per_page: number;
    total: number;
  };
}
